% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data_cif.R
\name{prep_data_cif}
\alias{prep_data_cif}
\title{Prepare Data for Standard CIF}
\usage{
prep_data_cif(
  data,
  ID = "USUBJID",
  TimeToRecovery = "TTRECOV",
  TimeToDeath = "TTDEATH",
  Recov_Censoring = "RECCNSR",
  Death_Censoring = "DTHCNSR",
  Treatment = "trt"
)
}
\arguments{
\item{data}{A data frame with columns for ID, time to recovery, time to death,
recovery censor, death censor, and treatment indicator.}

\item{ID}{Name of the patient ID column. Default is "USUBJID".}

\item{TimeToRecovery}{Name of the time-to-recovery column. Default "TTRECOV".}

\item{TimeToDeath}{Name of the time-to-death column. Default "TTDEATH".}

\item{Recov_Censoring}{Name of the recovery-censor column. Default "RECCNSR" (0=event,1=censor).}

\item{Death_Censoring}{Name of the death-censor column. Default "DTHCNSR" (0=event,1=censor).}

\item{Treatment}{Name of the treatment indicator column (0=control,1=treatment). Default "trt".}
}
\value{
A list with:
  \itemize{
    \item \code{data.w}: The processed data frame with columns \code{cn, etime, estatus, etype2, Treatment}.
    \item \code{Treatment}: Subset of \code{data.w} where \code{Treatment==1}.
    \item \code{Control}: Subset of \code{data.w} where \code{Treatment==0}.
  }
}
\description{
Cleans and prepares a single dataset for standard (competing risks) CIF analysis.
}
