% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{set_log_file}
\alias{set_log_file}
\title{Configure Automatic Logging}
\usage{
set_log_file(file, format = c("text", "json"))
}
\arguments{
\item{file}{File path for automatic logging. Set to \code{NULL} to disable.}

\item{format}{Log format: "text" (default) or "json".}
}
\value{
Invisibly returns the previous log file setting.
}
\description{
Sets up automatic logging of all join reports to a specified file.
When enabled, every \verb{*_join_spy()} call will append its report to the log.
}
\examples{
# Enable automatic logging to temp file
tmp <- tempfile(fileext = ".log")
old <- set_log_file(tmp)

# Disable logging and clean up
set_log_file(NULL)
unlink(tmp)

}
\seealso{
\code{\link[=log_report]{log_report()}}, \code{\link[=get_log_file]{get_log_file()}}
}
