% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_surface}
\alias{plot_surface}
\title{Plot Association Surface (3D or Perspective)}
\usage{
plot_surface(
  object,
  transition,
  n_grid = 40,
  theta = -30,
  phi = 25,
  col = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{"jmSurface"} object.}

\item{transition}{Character string specifying which transition to plot.}

\item{n_grid}{Integer grid resolution. Default \code{40}.}

\item{theta, phi}{Viewing angles for \code{persp}. Defaults \code{-30, 25}.}

\item{col}{Color palette. Default \code{hcl.colors(50, "viridis")}.}

\item{main}{Title. If \code{NULL}, auto-generated.}

\item{...}{Additional arguments passed to \code{persp}.}
}
\value{
Invisibly returns the prediction grid with fitted values.
}
\description{
Produces a 3D perspective plot of the estimated semi-parametric association
surface \eqn{\hat{f}_{rs}(\eta_1, \eta_2)} for a specified transition.
}
