% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{i_rnorm}
\alias{i_rnorm}
\alias{irnorm}
\alias{irunif}
\alias{irbinom}
\alias{irnbinom}
\alias{irpois}
\alias{isample}
\alias{i_runif}
\alias{i_rbinom}
\alias{i_rpois}
\alias{i_rnbinom}
\alias{i_sample}
\title{Random Number Iterators}
\usage{
i_rnorm(
  n,
  mean = 0,
  sd = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irnorm(
  n,
  mean = 0,
  sd = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_runif(
  n,
  min = 0,
  max = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irunif(
  n,
  min = 0,
  max = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_rbinom(
  n,
  size,
  prob,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irbinom(
  n,
  size,
  prob,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_rpois(
  n,
  lambda,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irpois(
  n,
  lambda,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_rnbinom(
  n,
  size,
  prob,
  mu,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irnbinom(
  n,
  size,
  prob,
  mu,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_sample(
  x,
  size,
  replace = FALSE,
  prob = NULL,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

isample(
  x,
  size,
  replace = FALSE,
  prob = NULL,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

i_runif(
  n,
  min = 0,
  max = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)

irunif(
  n,
  min = 0,
  max = 1,
  count = Inf,
  independent = !missing(seed) || !missing(kind),
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)
}
\arguments{
\item{n}{How many samples to compute per call; see e.g. \link{rnorm}.}

\item{mean}{see \link{rnorm}.}

\item{sd}{see \link{rnorm}.}

\item{count}{number of times that the iterator will fire.  If not
specified, it will fire values forever.}

\item{independent}{If TRUE, this iterator will keep its own private
random state, so that its output is reproducible and independent
of anything else in the program; this comes at some performance
cost. Default is FALSE \emph{unless} \code{seed} or \code{kind} are given.  If
\code{independent=TRUE} but neither \code{seed} nor \code{kind} are specified,
we will use the "L'Ecuyer-CMRG" generator with a seed value
taken from a package-private instance of \link{iRNGStream}.}

\item{seed}{A specific seed value for reproducibility. If given,
\code{independent=TRUE} is implied. This can be a single number (which
will be passed to \code{\link[=set.seed]{set.seed(seed, kind, normal.kind, sample.kind)}}; it can also be a vector containing a
complete, valid state for \link{.Random.seed}. If the latter,
arguments \code{kind}, etc. are ignored.}

\item{kind}{Which random number algorithm to use; passed along to
\link{set.seed}, If given, \code{independent=TRUE} is implied.}

\item{normal.kind}{Passed along to \link{set.seed}.}

\item{sample.kind}{Passed along to \link{set.seed}.}

\item{min}{see \link{runif}.}

\item{max}{see \link{runif}.}

\item{size}{see e.g. \link{rbinom}.}

\item{prob}{see e.g. \link{rbinom}.}

\item{lambda}{see \link{rpois}.}

\item{mu}{see \link{rnbinom}.}

\item{x}{see \link{isample}.}

\item{replace}{see \link{isample}.}
}
\value{
An iterator that is a wrapper around the corresponding
random number generator function.
}
\description{
These functions each construct an iterator that produces
random numbers of various distributions. Each one is a wrapper
around a base R function.
}
\details{
Originally from the \code{iterators} package.
}
\examples{

# create an iterator that returns three random numbers
it <- irnorm(1, count = 3)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it, NULL)

# iterators created with a specific seed will make reproducible values
it <- irunif(n=1, seed=314, kind="L'Ecuyer-CMRG")
nextOr(it) # 0.4936700
nextOr(it) # 0.5103891
nextOr(it) # 0.2338745

# the iRNGStream produces a sequence of well separated seed values,
rng.seeds <- iRNGStream(313)
it1 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))
it2 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))
it3 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))
take(it1, 5, "numeric") # 0 1 0 0 1
take(it2, 5, "numeric") # 0 1 0 0 0
take(it3, 5, "numeric") # 0 0 0 1 1

}
\seealso{
If you are creating multiple independent iterators,
\link{iRNGStream} will create well-separated seed values, which may
help avoid spurious correlations between iterators.
}
