% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_summary.R
\name{calc_summary}
\alias{calc_summary}
\title{Calculate summary statistics}
\usage{
calc_summary(
  injd,
  by = NULL,
  overall = TRUE,
  method = c("poisson", "negbin", "zinfpois", "zinfnb"),
  conf_level = 0.95,
  scale = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column according to which
compute summary statistics. It should refer to a (categorical) variable
that describes a grouping factor (e.g. "type of case or injury", "injury
location", "sports club"). Optional, defaults to \code{NULL}.}

\item{overall}{Logical, whether to calculate overall (for all the cohort) or
athlete-wise summary statistic (i.e. number of cases per cohort of per
athlete). Defaults to \code{TRUE}.}

\item{method}{Method to estimate the incidence (burden) rate. One of
"poisson", "negbin", "zinfpois" or "zinfnb"; that stand for Poisson method,
negative binomial method, zero-inflated Poisson and zero-inflated negative
binomial.}

\item{conf_level}{Confidence level (defaults to 0.95).}

\item{scale}{Logical, whether to transform the incidence and burden rates
output according to the unit of exposure (defaults to \code{TRUE}).}

\item{quiet}{Logical, whether or not to silence the warning messages
(defaults to \code{FALSE}).}

\item{...}{Other arguments passed on to \link[injurytools]{calc_incidence} function arguments.}
}
\value{
A data frame comprising of overall or athlete-wise epidemiological
summary statistics, that it's made up of the following columns:
\itemize{
\item \code{totalexpo}: total exposure that the athlete has been under
risk of suffering a sports-related health problem.
\item \code{ncases}: number of sports-related health problems suffered
by the athlete or overall in the team/cohort over the given period
specified by the \code{injd} data frame.
\item \code{ndayslost}: number of days lost by the athlete or overall
in the team/cohort due to the sports-related health problem over the
given period specified by the \code{injd} data frame.
\item \code{mean_dayslost}: average of number of days lost (i.e.
\code{ndayslost}) athlete-wise or overall in the team/cohort.
\item \code{median_dayslost}: median of number of days lost (i.e.
\code{ndayslost}) athlete-wise or overall in the team/cohort.
\item \code{qt25_dayslost} and \code{qt75_dayslost}: interquartile
range of number of days lost (i.e. \code{ndayslost}) athlete-wise or
overall in the team/cohort. \item \code{incidence}: case
incidence rate, number of cases per unit of exposure. \item
\code{burden}: case burden rate, number of days lost per unit of
exposure.
\item \code{incidence_sd} and \code{burden_sd}: estimated standard
deviation, by the specified \code{method} argument, of case incidence
(\code{incidence}) and case burden (\code{burden}). \item
\code{incidence_lower} and \code{burden_lower}: lower bound of, for
example, 95\% confidence interval (if \code{conf_level = 0.95}) of case
incidence (\code{incidence}) and case burden (\code{burden}).
\item \code{incidence_upper} and \code{burden_upper}: the same (as
above item) applies but for the upper bound.
}
Apart from this column names, they may further include these other columns
depending on the user's specifications to the function:
\itemize{
\item \code{by}: only if it is specified as an argument to
function.
\item \code{percent_ncases}: percentage (\%) of number of cases of
that type relative to all types of cases (if \code{by}
specified).
\item \code{percent_dayslost}: percentage (\%) of number of days lost
because of cases of that type relative to the total number of days
lost because of all types of cases (if \code{by}
specified).
}
}
\description{
Calculate epidemiological summary statistics such as case (e.g. injury)
incidence and case burden (see Bahr et al. 2018), including total number of
cases, number of days lost due to this event, total time of exposure etc., by
means of a (widely used) Poisson method, negative binomial, zero-inflated
poisson or zero-inflated negative binomial, on a athlete and overall basis.
}
\examples{
calc_summary(injd)
calc_summary(injd, overall = FALSE)
calc_summary(injd, by = "injury_type")
calc_summary(injd, by = "injury_type", overall = FALSE)
}
\references{
Bahr R., Clarsen B., & Ekstrand J. (2018). Why we should focus on the burden
of injuries and illnesses, not just their incidence. \emph{British Journal
of Sports Medicine}, 52(16), 1018–1021.
\doi{10.1136/bjsports-2017-098160}

Waldén M., Mountjoy M., McCall A., Serner A., Massey A., Tol J. L., ... &
Andersen T. E. (2023). Football-specific extension of the IOC consensus
statement: methods for recording and reporting of epidemiological data on
injury and illness in sport 2020. \emph{British journal of sports
medicine}.
}
