% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{ig_get_options}
\alias{ig_get_options}
\title{Get options/derivatives positions}
\usage{
ig_get_options(auth, mock_response = NULL)
}
\arguments{
\item{auth}{List. Authentication details from `ig_auth()`, including `cst`, `security`, `base_url`, `api_key`, and `acc_number`.}

\item{mock_response}{List or data frame. Optional mock response for testing, bypassing the API call.}
}
\value{
A tibble with options/derivative position details including deal ID, size, direction and instrument type.
}
\description{
Retrieves positions filtered for options/derivatives from the IG API. Returns a tibble with position details.
}
\examples{
\dontrun{
# Authenticate and get options positions
auth <- ig_auth(
  username = "your_username",
  password = "your_password",
  api_key = "your_api_key",
  acc_type = "DEMO",
  acc_number = "ABC123"
)
options <- ig_get_options(auth)
print(options)

# Using mock response for testing
mock_response <- data.frame(
  dealId = "DIXXXX",
  size = 1.5,
  direction = "BUY",
  instrumentType = "OPTION"
)
options <- ig_get_options(auth, mock_response = mock_response)
}

}
