% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\docType{data}
\name{tags}
\alias{tags}
\title{HTML tag functions}
\format{
An object of class \code{list} of length 115.
}
\usage{
tags
}
\description{
A named list of functions, one per HTML5 element. Access individual
tags with \code{tags$div(...)}, \code{tags$p(...)}, etc.
}
\details{
Named arguments become HTML attributes; unnamed arguments become
child nodes or text content.
}
\section{Boolean / valueless attributes}{

Pass \code{NA} or \code{TRUE} as the attribute value to produce a valueless
attribute (e.g. \code{disabled}). \code{FALSE} or \code{NULL} suppresses the
attribute entirely.
}

\section{Multi-value attributes}{

Character vectors of length > 1 are collapsed with a space, so
\code{class = c("a", "b")} renders as \code{class="a b"}.
}

\examples{
tags$p(class = "lead", "Hello, world!")
render(tags$div(id = "app", tags$h1("Title")))
}
\keyword{datasets}
