% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique-keys.R
\name{unique-keys}
\alias{unique-keys}
\alias{has_unique_key}
\alias{set_unique_key}
\title{Unique keys}
\usage{
has_unique_key(DT)

set_unique_key(DT, ...)
}
\arguments{
\item{DT}{A data.table}

\item{...}{keys to set}
}
\value{
\code{has_unique_key} returns \code{TRUE} if \code{DT} has a unique key, \code{FALSE} otherwise. 
\code{set_unique_key} runs \code{setkey(DT, ...)} then checks whether the key is unique, returning the keyed 
\code{data.table} if the key is unique, or an error message otherwise.
}
\description{
A \code{data.table}'s \code{key} need not be unique, but there are frequently circumstances
where non-unique keys can wreak havoc.
\code{has_unique_key} reports the existence of a unique key, and 
\code{set_unique_key} both sets and ensures the uniqueness of keys.
}
