% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_watch}
\alias{hgd_watch}
\title{Watch for changes in code files and refresh plots automatically.}
\usage{
hgd_watch(
  watch = list.files(pattern = "\\\\.R$", ignore.case = TRUE),
  on_change = function(changed_files) {
     print(changed_files)
 },
  interval = 1,
  on_start = hgd_browse,
  on_exit = NULL,
  on_error = print,
  reset_par = TRUE,
  ...
)
}
\arguments{
\item{watch}{Paths that are watched for changes (see \code{\link[utils:changedFiles]{utils::fileSnapshot()}})}

\item{on_change}{Will be called when a file changes.}

\item{interval}{Time interval in which changes are detected (in seconds).}

\item{on_start}{Will be called after the httpgd server is started
(may be set to \code{NULL}).}

\item{on_exit}{Will be called before the server is closed
(may be set to \code{NULL}).}

\item{on_error}{Will be called when on_change throws an error
(may be set to \code{NULL}).}

\item{reset_par}{If set to \code{TRUE}, global graphics parameters will be saved
on device start and reset every time \code{\link[unigd:ugd_clear]{unigd::ugd_clear()}} is called (see
\code{\link[graphics:par]{graphics::par()}}).}

\item{...}{Additional parameters passed to \code{hgd(webserver=FALSE, ...)}}
}
\value{
No return value, called for side effects.
}
\description{
This function may be used to rapidly develop visualizations
by replacing a workflow of reloading and executing code manually.
}
\examples{
\dontrun{

# --- my_code.R ---

plot(rnorm(100), col = "red")

# --- Other file / interactive ---

hgd_watch(
  watch = "my_code.R", # When my_code.R changes...
  on_change = function(...) {
    source("my_code.R") # ...call updated plot function.
  }
)
}
}
