% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_median_survival.R
\name{tar_median_survival}
\alias{tar_median_survival}
\title{Plot Survival Curves and Save with Median Annotations}
\usage{
tar_median_survival(
  df,
  var,
  time_col = "time",
  status_col = "status",
  output_file = NULL
)
}
\arguments{
\item{df}{A data frame containing the survival data.}

\item{var}{A variable used for grouping the survival curves.}

\item{time_col}{A string specifying the name of the column representing time.}

\item{status_col}{A string specifying the name of the column representing status.}

\item{output_file}{Optional output path for saving the plot. If `NULL`
(default), the function does not write a file.}
}
\value{
A `ggsurvplot` object (invisibly). Optionally writes a PNG file.
}
\description{
This function fits a survival model, plots the survival curves, and
annotates median survival times. The plot can optionally be saved to file.
}
\examples{
\donttest{
# Example dataset
df_survival <- structure(
  list(
    status = c(1, 0, 1, 1, 1, 1, 0, 1, 1, 0),
    primorgan = structure(
      c(1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 2L),
      levels = c("Colon", "Rectum"),
      class = "factor"
    ),
    sex = structure(
      c("male", "female", "male", "male", "male",
        "male", "male", "male", "male", "female"),
      label = "Gender"
    ),
    time = c(4.26, 49.52, 18.05, 11.04, 47.67, 8.03, 76.2, 15.44, 22.74, 50.64),
    subtype = structure(
      c(2L, 1L, 2L, 3L, 2L, 3L, 1L, 1L, 1L, 2L),
      levels = c("adenocarcinoma", "mucinous", "signet ring cell"),
      label = "Histological subtype",
      class = "factor"
    )
  ),
  row.names = c(NA, -10L),
  class = c("tbl_df", "tbl", "data.frame")
)

tar_median_survival(
  df = df_survival,
  var = sex,
  time_col = "time",
  status_col = "status",
  output_file = file.path(tempdir(), "survival_sex.png")
)
}
}
