% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{rq_stat}
\alias{rq_stat}
\alias{rq_stat_cond_cov}
\alias{rq_stat_uncond_cov}
\title{rq_stat}
\usage{
rq_stat(Y, Z, rq.pts = seq(0.1, 0.9, by = 0.1))

rq_stat_cond_cov(Y, Z, X, rq.pts = seq(0.1, 0.9, by = 0.1))

rq_stat_uncond_cov(Y, Z, X, rq.pts = seq(0.1, 0.9, by = 0.1))
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{rq.pts}{Sequence of quantile points at which to evaluate the test. Default is seq(.1, .9, by = .1). Should not go beyond 0 and 1.}

\item{X}{Additional pre-treatment covariates to adjust for in estimation, but
not to interact with treatment.}
}
\value{
The value of the test.
}
\description{
rq_stat is the Kolmogorov-smirnov statistic via quantile regression with covariates without further adjustment.

rq_stat_cond_cov does Kolmogorov-smirnov statistic via quantile regression
with covariates, with a conditional approach; see Koenker and Xiao (2002).

rq_stat_uncond_cov implements a Kolmogorov-smirnov statistic via quantile regression with covariates,
unconditional approach; see Firpo (2007).
}
\details{
Warning: This function supresses all warnings of the `rq()` method call.

Warning: This function supresses all warnings of the `rq()` method call.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
rq_stat(df$Yobs, df$Z)

df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
rq_stat_cond_cov(df$Yobs, df$Z, df$A)

df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
rq_stat_uncond_cov(df$Yobs, df$Z, df$A)

}
