% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{KS_stat}
\alias{KS_stat}
\title{KS_stat}
\usage{
KS_stat(Y, Z, tau = NULL, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{tau}{Value of treatment effect for shifting Y1. Default is NULL (Y1 not shifted).}

\item{alternative}{Direction of test ("two.sided", "less", "greater")}
}
\value{
The value of the test.
}
\description{
Calculate classic (not shifted) KS statistic; code is a modified version of R's ks.test().
}
\details{
If tau passed, Y1 will be shifted by tau.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
KS_stat(df$Yobs, df$Z)

}
\seealso{
detect_idiosyncratic
}
