% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_diff.R
\name{rel_diff}
\alias{rel_diff}
\title{Relative Difference between two Arrays or Data Frames}
\usage{
rel_diff(x, y, pct = TRUE, epsilon = 10 * .Machine$double.eps)
}
\arguments{
\item{x}{An array or data frame, considered the reference values}

\item{y}{Comparison array or data frame}

\item{pct}{Logical; if \code{TRUE} the relative differences are multiplied by 100, giving values in percent difference from \code{x}.}

\item{epsilon}{Threshold for values near zero}
}
\value{
An array or data frame the same size as \code{x} and \code{y} containing the relative differences
}
\description{
Calculates the relative difference, defined as
\deqn{\frac{\vert x - y \vert}{x} }
between two arrays or data frames, where \code{x} are considered reference values.
}
\details{
Beyond the obvious, a natural use case is to compare coefficients for alternative models for the same data, e.g., a classical
and a robust model.
}
\examples{
# simple example
m1 <- cbind(c(0,1), c(1,1))
m2 <- cbind(c(0,1), c(1.01,1.11))
rel_diff(m1, m2, pct = FALSE) 
rel_diff(m1, m2) 

# compare coefficients
data(Skulls)

# fit manova model, classically and robustly
sk.mlm <- lm(cbind(mb, bh, bl, nh) ~ epoch, data=Skulls)
sk.rlm <- robmlm(cbind(mb, bh, bl, nh) ~ epoch, data=Skulls)
rel_diff(coef(sk.mlm),
         coef(sk.rlm))
}
\seealso{
\code{link{robmlm}}
}
