% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{myers}
\alias{myers}
\title{Myers' Blended Index of Age Heaping}
\usage{
myers(x, ageMin = 23, ageMax = 82, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{ageMin}{minimum age to include (default 23).}

\item{ageMax}{maximum age to include (default 82).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing Myers' blended index.
}
\description{
Myers' index measures preferences for each of the ten possible terminal
digits (0-9) as a blended index. It is based on the principle that in the
absence of age heaping, the aggregate population of each age ending in one
of the digits 0 to 9 should represent 10 percent of the total population.
}
\details{
Calculate Myers' blended index to measure digit preference in age data.


The index uses a blending technique that weights earlier ages more for
digit preference calculation and later ages more for avoidance, creating
a balanced measure across the age range.

The theoretical range is 0 to 90:
\itemize{
  \item 0: no digit preference (perfect data)
  \item 90: all ages reported with same terminal digit (maximum heaping)
}
}
\examples{
# No heaping (uniform ages)
set.seed(42)
age_uniform <- sample(23:82, 10000, replace = TRUE)
myers(age_uniform)  # Should be close to 0

# Strong heaping on ages ending in 0 or 5
age_heaped <- sample(seq(25, 80, by = 5), 5000, replace = TRUE)
myers(age_heaped)  # Should be high

}
\references{
Myers, R. J. (1940). Errors and bias in the reporting of ages in census
data. \emph{Transactions of the Actuarial Society of America}, \strong{41},
395-415.

Myers, R. J. (1954). Accuracy of age reporting in the 1950 United States
Census. \emph{Journal of the American Statistical Association},
\strong{49}(268), 826-831.
}
\seealso{
\code{\link{bachi}} for Bachi's index,
  \code{\link{whipple}} for Whipple's index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
