% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discount.R
\name{discount}
\alias{discount}
\title{Discount health impacts}
\usage{
discount(
  output_attribute = NULL,
  impact = NULL,
  discount_rate = NULL,
  n_years = NULL,
  discount_shape = NULL,
  inflation_rate = NULL
)
}
\arguments{
\item{output_attribute}{\code{List} produced by \code{healthiar::attribute_health()}, \code{healthiar::attribute_lifetable()} or \code{healthiar::compare()} as results.}

\item{impact}{\code{Numberic value} referring to the health impacts to be monetized (without attribute function). If a \code{Numberic vector} is entered multiple assessments (by year) will be carried out. Be aware that the value for year 0 (current) must be entered, while n_years does not include the year 0. Thus, length of impact = n_years + 1.}

\item{discount_rate}{\code{Numeric value} showing the discount rate for future years. If it is a nominal discount rate, no inflation is to be entered. If it is a real discount rate, the result can be adjusted by entering inflation in this function.}

\item{n_years}{\code{Numeric value} referring to number of years in the future to be considered in the discounting and/or inflation. Be aware that the year 0 (without discounting/inflation, i.e. the present) is not be counted here. If a vector is entered in the argument impact, n_years does not need to be entered (length of impact = n_years + 1).}

\item{discount_shape}{\code{String} referring to the assumed equation for the discount factor. By default: \code{"exponential"}. Otherwise: \code{"hyperbolic_harvey_1986"} or \code{"hyperbolic_mazur_1987"}.}

\item{inflation_rate}{\code{Numeric value} between 0 and 1 referring to the annual inflation (increase of prices). Only to be entered if nominal (not real) discount rate is entered in the function. Default value = NULL (assuming no nominal discount rate).}
}
\value{
This function returns a \code{list} containing:

1) \code{monetization_main} (\code{tibble}) containing the main monetized results;
\itemize{
 \item \code{monetized_impact} (\code{numeric} column)
 \item \code{discount_factor} (\code{numeric} column) calculated based on the entered \code{discount_rate}
 \item And many more
}

2) \code{monetization_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{results_by_year} (\code{tibble})
 \item \code{health_raw} (\code{tibble}) containing the monetized results for each for each combination of input uncertainty that were provided to the initial \code{attribute_health()} call
}

If the argument \code{output_attribute} was specified, then the two results elements are added to the existing output.
}
\description{
This function calculates discounted health impacts (without valuation).
}
\details{
\strong{Methodology}

This function applies a discount \insertCite{Frederick2002_jel,Harvey1986_ms,Mazur1987_book}{healthiar},
optionally with inflation \insertCite{Brealey2023_book}{healthiar},
to attributable health impacts into the future.

From an epidemiological perspective, the attributable health impacts
cannot be discounted (or inflated), only economic costs/benefits can.
However, in some economic analyses the attributable health impacts are discounted (and/or inflated)
as a previous step to valuating them. For this specific purpose, this function is offered.


Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#monetization}{Monetization}}
}
\examples{
# Goal: discount attributable health impacts
results <- discount(
  impact = 20000,
  discount_shape = "exponential",
  discount_rate = 0.03,
  n_years = 20
)
results$monetization_main$monetized_impact


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{attribute_health}}, \code{\link{attribute_health}}
  \item Alternative: \code{\link{monetize}}
}
}
\author{
Alberto Castro & Axel Luyten
}
