% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sih.R
\name{sih_variables}
\alias{sih_variables}
\title{List SIH Variables}
\usage{
sih_variables(year = NULL, search = NULL)
}
\arguments{
\item{year}{Integer. If provided, returns variables available for that
specific year (reserved for future use). Default: NULL.}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the SIH microdata,
including descriptions and value types.
}
\examples{
sih_variables()
sih_variables(search = "diag")
sih_variables(search = "valor")
}
\seealso{
Other sih: 
\code{\link{sih_cache_status}()},
\code{\link{sih_clear_cache}()},
\code{\link{sih_data}()},
\code{\link{sih_dictionary}()},
\code{\link{sih_info}()},
\code{\link{sih_years}()}
}
\concept{sih}
