% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns.R
\name{pns_dictionary}
\alias{pns_dictionary}
\title{Download PNS variable dictionary}
\usage{
pns_dictionary(year = 2019, cache_dir = NULL, refresh = FALSE)
}
\arguments{
\item{year}{Numeric. Year to get dictionary for (2013 or 2019).
Default is 2019.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A tibble with variable definitions.
}
\description{
Downloads and returns the variable dictionary for PNS microdata.
The dictionary is cached locally to avoid repeated downloads.
}
\details{
The dictionary includes variable names, labels, and response categories
for the PNS microdata. This is useful for understanding the structure
of the data returned by \code{\link{pns_data}}.
}
\section{Data source}{

Dictionaries are downloaded from the IBGE FTP server:
\verb{https://ftp.ibge.gov.br/PNS/}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# get dictionary for 2019
dict <- pns_dictionary(year = 2019, cache_dir = tempdir())

# get dictionary for 2013
dict_2013 <- pns_dictionary(year = 2013, cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
