% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ans.R
\name{ans_operators}
\alias{ans_operators}
\title{Download ANS Operators Registry}
\usage{
ans_operators(status = "active", vars = NULL, cache = TRUE, cache_dir = NULL)
}
\arguments{
\item{status}{Character. Filter by operator status:
\itemize{
\item \code{"active"}: Active operators only (default).
\item \code{"cancelled"}: Cancelled operators only.
\item \code{"all"}: Both active and cancelled.
}}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all 20 variables. Use \code{ans_variables(type = "operators")}
to see available variables.}

\item{cache}{Logical. If TRUE (default), caches downloaded data.}

\item{cache_dir}{Character. Directory for caching.}
}
\value{
A tibble with operator data. When \code{status = "all"},
includes a \code{status} column indicating "active" or "cancelled".
}
\description{
Downloads and returns the current registry of health plan operators
from the ANS open data portal. This is a snapshot of the current
operator status (not time-series data).
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# active operators
ops <- ans_operators()

# all operators (active + cancelled)
all_ops <- ans_operators(status = "all")
\dontshow{\}) # examplesIf}
}
\seealso{
Other ans: 
\code{\link{ans_cache_status}()},
\code{\link{ans_clear_cache}()},
\code{\link{ans_data}()},
\code{\link{ans_info}()},
\code{\link{ans_variables}()},
\code{\link{ans_years}()}
}
\concept{ans}
