/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5TSmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5TSpkg.h"    

#ifdef H5_HAVE_WIN_THREADS

#ifdef H5_HAVE_THREADSAFE
#if defined(H5_BUILT_AS_DYNAMIC_LIB) && defined(H5_HAVE_WIN32_API)
static herr_t H5TS__win32_thread_enter(void);
static herr_t H5TS__win32_thread_exit(void);
#endif
#endif

#ifdef H5_HAVE_THREADSAFE_API

H5_DLL BOOL CALLBACK
H5TS__win32_process_enter(PINIT_ONCE InitOnce, PVOID Parameter, PVOID *lpContex)
{
    BOOL ret_value = TRUE;

    FUNC_ENTER_PACKAGE_NAMECHECK_ONLY

    
    if (H5_UNLIKELY(H5TS__init_package() < 0))
        HGOTO_DONE(FALSE);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 

#if defined(H5_BUILT_AS_DYNAMIC_LIB) && defined(H5_HAVE_WIN32_API)

static herr_t
H5TS__win32_thread_enter(void)
{
    FUNC_ENTER_PACKAGE_NAMECHECK_ONLY

    

    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(SUCCEED)
} 

static herr_t
H5TS__win32_thread_exit(void)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE_NAMECHECK_ONLY

    

    
    if (H5TS_thrd_info_key_g != TLS_OUT_OF_INDEXES) {
        LPVOID lpvData;

        if (H5_UNLIKELY(H5TS_key_get_value(H5TS_thrd_info_key_g, &lpvData) < 0))
            HGOTO_DONE(FAIL);
        if (lpvData)
            H5TS__tinfo_destroy(lpvData);
    }

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 

BOOL WINAPI
DllMain(_In_ HINSTANCE hinstDLL, _In_ DWORD fdwReason, _In_ LPVOID lpvReserved)
{
    

    BOOL fOkay = true;

    switch (fdwReason) {
        case DLL_PROCESS_ATTACH:
            break;

        case DLL_PROCESS_DETACH:
            break;

        case DLL_THREAD_ATTACH:
            if (H5TS__win32_thread_enter() < 0)
                fOkay = false;
            break;

        case DLL_THREAD_DETACH:
            if (H5TS__win32_thread_exit() < 0)
                fOkay = false;
            break;

        default:
            
            fOkay = false;
            break;
    }

    return fOkay;
}
#endif 
#endif 

#endif 
