/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Pmodule.h" 
#define H5P_TESTING    

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Iprivate.h" 
#include "H5Ppkg.h"     

char *
H5P__get_class_path_test(hid_t pclass_id)
{
    H5P_genclass_t *pclass;           
    char           *ret_value = NULL; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (pclass = (H5P_genclass_t *)H5I_object_verify(pclass_id, H5I_GENPROP_CLS)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, NULL, "not a property class");

    
    if (NULL == (ret_value = H5P__get_class_path(pclass)))
        HGOTO_ERROR(H5E_PLIST, H5E_NOTFOUND, NULL, "unable to query full path of class");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

hid_t
H5P__open_class_path_test(const char *path)
{
    H5P_genclass_t *pclass    = NULL;            
    hid_t           ret_value = H5I_INVALID_HID; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == path || *path == '\0')
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, H5I_INVALID_HID, "invalid class path");

    
    if (NULL == (pclass = H5P__open_class_path(path)))
        HGOTO_ERROR(H5E_PLIST, H5E_NOTFOUND, H5I_INVALID_HID, "unable to find class with full path");

    
    if ((ret_value = H5I_register(H5I_GENPROP_CLS, pclass, true)) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, H5I_INVALID_HID, "unable to register property list class");

done:
    if (H5I_INVALID_HID == ret_value && pclass)
        H5P__close_class(pclass);

    FUNC_LEAVE_NOAPI(ret_value)
} 
