% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curepwe_logml_pp.R
\name{curepwe.logml.pp}
\alias{curepwe.logml.pp}
\title{Log marginal likelihood of a standard cure rate (CurePWE) model under the power prior (PP)}
\usage{
curepwe.logml.pp(
  post.samples,
  bridge.args = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{post.samples}{output from \code{\link[=curepwe.pp]{curepwe.pp()}} giving posterior samples of a CurePWE model under the power prior (PP),
with an attribute called 'data' which includes the list of variables specified in the data block
of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup}
in \code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method
in cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
If the power prior parameter (\eqn{a_0}) is equal to zero, then the function will return the same result as the output
from \code{\link[=curepwe.logml.post]{curepwe.logml.post()}}.

If the power prior parameters (\eqn{a_0}) is non-zero, the function will return a \code{list} with the following objects

\describe{
\item{model}{"curepwe_pp"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the normalizing constant of the power prior (PP) using all data sets}

\item{bs.hist}{an object of class \code{bridge} or \code{bridge_list} containing the output from using
\code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}} to compute the logarithm of the normalizing constant of the PP using historical
data set}

\item{min_ess_bulk}{the minimum estimated bulk effective sample size of the MCMC sampling}

\item{max_Rhat}{the maximum Rhat}
}
}
\description{
Uses Markov chain Monte Carlo (MCMC) and bridge sampling to estimate the logarithm of the marginal
likelihood of a CurePWE model under the power prior (PP).

The arguments related to MCMC sampling are utilized to draw samples from the power prior (PP).
These samples are then used to compute the logarithm of the normalizing constant of the PP using only historical
data set.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1684)
    data(E1690)
    ## take subset for speed purposes
    E1684 = E1684[1:100, ]
    E1690 = E1690[1:50, ]
    ## replace 0 failure times with 0.50 days
    E1684$failtime[E1684$failtime == 0] = 0.50/365.25
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    E1684$cage = as.numeric(scale(E1684$age))
    E1690$cage = as.numeric(scale(E1690$age))
    data_list = list(currdata = E1690, histdata = E1684)
    nbreaks = 3
    probs   = 1:nbreaks / nbreaks
    breaks  = as.numeric(
      quantile(E1690[E1690$failcens==1, ]$failtime, probs = probs)
    )
    breaks  = c(0, breaks)
    breaks[length(breaks)] = max(10000, 1000 * breaks[length(breaks)])
    d.pp = curepwe.pp(
      formula = survival::Surv(failtime, failcens) ~ treatment + sex + cage + node_bin,
      data.list = data_list,
      breaks = breaks,
      a0 = 0.5,
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
    curepwe.logml.pp(
      post.samples = d.pp,
      bridge.args = list(silent = TRUE),
      chains = 1, iter_warmup = 1000, iter_sampling = 2000
    )
  }
}
}
\references{
Chen, M.-H. and Ibrahim, J. G. (2000). Power prior distributions for Regression Models. Statistical Science, 15(1).

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
