% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDest-methods.R
\name{MTDest-methods}
\alias{MTDest-methods}
\title{Methods for objects of class \code{"MTDest"}}
\arguments{
\item{x}{An object of class \code{"MTDest"} or \code{"summary.MTDest"},
depending on the method.}

\item{object}{An object of class \code{"MTDest"} (used by summary, coef, and
logLik methods).}

\item{...}{Further arguments passed to or from other methods (ignored).}
}
\value{
\describe{
\item{\code{print.MTDest}}{Invisibly returns the \code{"MTDest"} object, after
displaying its lag set, state space, final log-likelihood, and iteration
count (if available).}
\item{\code{print.summary.MTDest}}{Invisibly returns the \code{"summary.MTDest"} object,
after displaying its contents: lambdas; transition matrices; independent
distribution; log-likelihood; oscillations (if available); and
iteration diagnostics (if available).}
\item{\code{summary.MTDest}}{An object of class \code{"summary.MTDest"}.}
\item{\code{coef.MTDest}}{A list with estimated \code{lambdas}, \code{pj}, and \code{p0}.}
\item{\code{logLik.MTDest}}{ An object of class \code{"logLik"} with attributes
\code{df} (number of free parameters) and \code{nobs} (effective sample size).}
}
}
\description{
Printing, summarizing, and extracting information from EM fits of Mixture
Transition Distribution (MTD) models.
}
\details{
These methods handle objects returned by \code{\link{MTDest}} (class \code{"MTDest"}):
\itemize{
\item \code{print.MTDest()} displays a compact summary of the fitted model:
the lag set (\code{S}), the state space (\code{A}), the final
log-likelihood, and, if available, the number of EM updates performed.

\item \code{summary.MTDest()} collects key components of the object into a
readable summary list (class \code{"summary.MTDest"}), including lambdas,
transition matrices, independent distribution (if present), log-likelihood,
oscillations (if available), and iteration diagnostics.

\item \code{print.summary.MTDest()} prints the summary in a readable format,
including lambdas, transition matrices, independent distribution,
log-likelihood, oscillations (if available), and iteration diagnostics
(if available).

\item \code{coef.MTDest()} extracts the estimated mixture weights
(\code{lambdas}), the list of transition matrices (\code{pj}), and the
independent distribution (\code{p0}).

\item \code{logLik.MTDest()} returns the log-likelihood as an object of class
\code{"logLik"}, with attributes \code{df} (number of free parameters
under the multimatrix model) and \code{nobs} (effective sample size).
}
}
\examples{
\dontrun{
set.seed(1)
MTD <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.01)
X <- perfectSample(MTD, N = 200)  # small N to keep examples fast
init <- list(
  p0 = c(0.4, 0.6),
  lambdas = c(0.05, 0.45, 0.5),
  pj = list(
    matrix(c(0.2, 0.8, 0.45, 0.55), byrow = TRUE, ncol = 2),
    matrix(c(0.25, 0.75, 0.3, 0.7),  byrow = TRUE, ncol = 2)
  )
)
fit <- MTDest(X, S = c(1, 3), init = init, iter = TRUE)
print(fit)
summary(fit)
coef(fit)
logLik(fit)
BIC(fit)
}

}
\seealso{
\code{\link{MTDest}}, \code{\link{as.MTD}}
}
