% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize.r
\name{h5_create_group}
\alias{h5_create_group}
\title{Create an HDF5 Group}
\usage{
h5_create_group(file, name)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the group to create (e.g., "/g1/g2").}
}
\value{
Invisibly returns \code{NULL}. This function is called for its side effects.
}
\description{
Explicitly creates a new group (or nested groups) in an HDF5 file.
This is useful for creating an empty group structure.
}
\examples{
file <- tempfile(fileext = ".h5")
h5_create_file(file)

# Create a nested group structure
h5_create_group(file, "/data/experiment/run1")
h5_ls(file)

unlink(file)
}
