% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.Delta.given.power.R
\name{find.Delta.given.power}
\alias{find.Delta.given.power}
\title{Function to solve for the mean frequency effect size given target power for one-sample simulations.}
\usage{
find.Delta.given.power(K, timing, alpha, power, Imax)
}
\arguments{
\item{K}{Number of analysis (including the final analysis).}

\item{timing}{Numeric vector of information fractions at each analysis, with values in \eqn{(0, 1)} and length equal to \code{K}.}

\item{alpha}{Overall Type I error.}

\item{power}{Target power of thw group sequenctial test.}

\item{Imax}{Maximum information at the final analysis.}
}
\value{
A numeric value giving the mean frequency effect size \eqn{\Delta} that achieves the specified power.
}
\description{
Computes the mean frequency difference parameter \eqn{\Delta} that achieves a specified power for a two-sided group sequential
test.
}
\examples{
# Toy Example: n = 800, two interim analysi planned at 50\% and
# 75\% if maximum information, along with a final analysis
# at 100\% maximum information. Assuming the maximum
# information is 100, overall Type I error at 0.05 and power at 0.8.
find.Delta.given.power(K = 3, timing = c(0.5, 0.75, 1),
 alpha = 0.05, power = 0.8, Imax = 100)
}
