% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Constant.LR.R
\name{TwoSample.Constant.LR}
\alias{TwoSample.Constant.LR}
\title{Function to compute calibration constants for the two-sample generalized log-rank statistics.}
\usage{
TwoSample.Constant.LR(data)
}
\arguments{
\item{data}{A data frame generated by \code{TwoSamaple.generate.sequential()}.}
}
\value{
A numeric vector of length 2:
\itemize{
\item The calibration constant \code{power.const}. Defined as the integral of the generalized log-rank statistics' weight
function times the control group's mean frequency increment over \code{[0,3]}.
\item The estimated asymptotic variance of the integrated two-sample generalized log-rank statistics over \code{[0,3]}.
}
}
\description{
Computes two quantities used for power/effect-size calibration of the two-sample generalized log-rank statistics.
The function evaluates the generalized log-rank statistics up to a
fixed event-time horizon \code{tau = 3}, then returns (i) an integral
\eqn{\int_0^{\tau} K_{LR}(t)\, d\mu_1(t)} based on the control group mean-frequency
increment and (ii) the asymptotic variance of the integrated statistic.
}
