% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\name{gsDesignTune}
\alias{gsDesignTune}
\title{Create a tune job for \code{gsDesign::gsDesign()}}
\usage{
gsDesignTune(..., upper = NULL, lower = NULL)
}
\arguments{
\item{...}{Arguments to \code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}}. Any argument can be replaced
by a \verb{tune_*()} specification.}

\item{upper, lower}{Optional spending specifications provided as
\code{SpendingSpec} or \code{SpendingFamily}. When supplied, these are translated to
the underlying \verb{(sfu, sfupar)} / \verb{(sfl, sflpar)} arguments.}
}
\value{
A \code{GSDTuneJob} R6 object.
}
\description{
\code{gsDesignTune()} is a drop-in replacement for \code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}} that
returns a tune job object instead of immediately running a single design.
}
\details{
Any argument can be replaced by a tuning specification created by \verb{tune_*()}.
Use \code{SpendingSpec} / \code{SpendingFamily} via \verb{upper=} and \verb{lower=} for
dependency-aware spending function tuning.
}
\examples{
job <- gsDesignTune(
  k = 3,
  test.type = 4,
  alpha = tune_values(list(0.025, 0.03))
)
\donttest{
job$run(strategy = "grid", parallel = FALSE, seed = 1)
utils::head(job$results())
}
}
