% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_sim.R
\name{nb_sim}
\alias{nb_sim}
\title{Simulate recurrent events with fixed follow-up}
\usage{
nb_sim(
  enroll_rate,
  fail_rate,
  dropout_rate = NULL,
  max_followup = NULL,
  n = NULL,
  block = c(rep("Control", 2), rep("Experimental", 2)),
  event_gap = 0
)
}
\arguments{
\item{enroll_rate}{A data frame with columns \code{rate} and \code{duration} defining
the piecewise constant enrollment rates.}

\item{fail_rate}{A data frame with columns \code{treatment} and \code{rate} defining
the exponential failure rate for each treatment group.
Optionally, a \code{dispersion} column can be provided to generate data from
a negative binomial distribution. The dispersion parameter \code{k} is
such that \eqn{\mathrm{Var}(Y) = \mu + k \mu^2}.}

\item{dropout_rate}{A data frame with columns \code{treatment}, \code{rate},
and \code{duration} defining the piecewise constant dropout rates.}

\item{max_followup}{Numeric. Maximum duration of follow-up for
each individual (relative to their randomization time).}

\item{n}{Total sample size. If NULL, it is estimated from \code{enroll_rate}.
If provided, enrollment stops when \code{n} subjects are recruited.}

\item{block}{Block vector for treatment allocation. Default is
\code{c(rep("Control", 2), rep("Experimental", 2))}.
If NULL, simple randomization is used (treatments are assigned with
equal probability). If provided, it specifies the block structure,
for example, \code{c(rep("A", 2), rep("B", 2))} assigns 2 to group A and
2 to group B in each block.}

\item{event_gap}{Numeric. Gap duration after each event during which
no new events are counted. Default is 0.}
}
\value{
A data frame (tibble) with columns:
\describe{
\item{id}{Subject identifier}
\item{treatment}{Treatment group}
\item{enroll_time}{Time of enrollment relative to trial start}
\item{tte}{Time to event or censoring relative to randomization}
\item{calendar_time}{Calendar time of event or censoring (enroll_time + tte)}
\item{event}{Binary indicator: 1 for event, 0 for censoring}
}
Multiple rows per subject are returned (one for each event, plus one for the final censoring time).
}
\description{
Simulates recurrent events for a clinical trial with piecewise constant enrollment,
exponential failure rates (Poisson process), and piecewise exponential dropout.
}
\details{
The simulation generates data consistent with the negative binomial models described
by Friede and Schmidli (2010) and Mütze et al. (2019). Specifically, it simulates
a Gamma-distributed frailty variable for each individual (if dispersion > 0),
which acts as a multiplier for that individual's event rate. Events are then
generated according to a Poisson process with this subject-specific rate.

More explicitly, for a subject with baseline rate \eqn{\lambda} and exposure time
\eqn{t}, the model used here is a Gamma--Poisson mixture:
\deqn{\Lambda_i \sim \mathrm{Gamma}(\text{shape}=1/k,\ \text{scale}=k\lambda), \quad Y_i \mid \Lambda_i \sim \mathrm{Poisson}(\Lambda_i t).}
Marginally, \eqn{Y_i} follows a negative binomial distribution with
\eqn{\mathrm{E}[Y_i]=\mu=\lambda t} and \eqn{\mathrm{Var}(Y_i)=\mu + k\mu^2}.
This \eqn{k} is the package dispersion parameter (and corresponds to
\eqn{1/\theta} in \code{\link[MASS:glm.nb]{MASS::glm.nb()}} terminology).
}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(treatment = c("Control", "Experimental"), rate = c(0.5, 0.3))
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.1, 0.05), duration = c(100, 100)
)
sim <- nb_sim(enroll_rate, fail_rate, dropout_rate, max_followup = 2, n = 20)
head(sim)
}
\references{
Friede, T., & Schmidli, H. (2010). Blinded sample size reestimation with
count data: methods and applications in multiple sclerosis.
\emph{Statistics in Medicine}, 29(10), 1145--1156. \doi{10.1002/sim.3861}

Mütze, T., Glimm, E., Schmidli, H., & Friede, T. (2019).
Group sequential designs for negative binomial outcomes.
\emph{Statistical Methods in Medical Research},
28(8), 2326--2347. \doi{10.1177/0962280218773115}
}
