% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_assessment.R
\name{CFS_scale}
\alias{CFS_scale}
\title{Quality assessment: ring-width measurement at plot level}
\usage{
CFS_scale(
  target_site,
  ref_sites,
  scale.label_data_ref = "",
  scale.max_dist_km = 20,
  scale.N_nbs = 10
)
}
\arguments{
\item{target_site}{data.table with columns uid_site, site_id, species, longitude and latitude}

\item{ref_sites}{reference sites including species, uid_site, latitude, longitude, uid_radius, year, rw_mm in long format}

\item{scale.label_data_ref}{description of ref_sites}

\item{scale.max_dist_km}{maximum distance to search the neighbors in km}

\item{scale.N_nbs}{number of nearest-neighbors (maximum)}
}
\value{
A data table containing the median ring-width measurements of the involved sites, along with the distances from the specific site
}
\description{
Apply a k-nearest neighbors (k-NN) method based on geographic location for the same species.
It compares the median tree-ring measurements of a specific site to those of nearby sites
}
\examples{
# loading formatted
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
all.sites <- dt.samples_trt$tr_all_wide[,.N, by = c("species", "uid_site", "site_id")][, N:=NULL]
dupes <- all.sites[, .N, by = .(species, site_id)][N > 1]
# e.g. taking the target sites
target_site <- all.sites[c(1,2), -"uid_site"]
ref.sites <- merge(
dt.samples_trt$tr_all_wide[,c("species", "uid_site", "site_id",
 "latitude","longitude", "uid_radius")],
dt.samples_trt$tr_all_long$tr_7_ring_widths, by = c("uid_radius"))
dt.scale <- CFS_scale( target_site = target_site, ref_sites = ref.sites,
scale.label_data_ref = "demo-samples", scale.max_dist_km = 200, scale.N_nbs = 2)

}
