% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotGeneTotalVsNtr}
\alias{PlotGeneTotalVsNtr}
\title{Gene plot comparing total RNA vs the NTR}
\usage{
PlotGeneTotalVsNtr(
  data,
  gene,
  slot = DefaultSlot(data),
  columns = NULL,
  log = TRUE,
  show.CI = FALSE,
  aest = NULL,
  size = 2
)
}
\arguments{
\item{data}{the grandR object to get the data to be plotted from}

\item{gene}{the gene to plot}

\item{slot}{the slot of the grandR object to get the data from}

\item{columns}{which columns (i.e. samples or cells) to show (see details)}

\item{log}{show the x axis (total RNA) in log scale}

\item{show.CI}{show confidence intervals; one of TRUE/FALSE (default: FALSE)}

\item{aest}{parameter to set the visual attributes of the plot}

\item{size}{the point size used for plotting; overridden if size is defined via aest}
}
\value{
a ggplot object.
}
\description{
Plot the total RNA expression vs the new-to-total RNA ratio for a gene
}
\details{
The value of the aest parameter must be an \emph{Aesthetic mapping} as generated by \link[ggplot2]{aes}.

The table used for plotting is the table returned by \link{GetData} with coldata set to TRUE, i.e. you can use all names from the \link{Coldata} table for aest.

By default, aest is set to aes(color=Condition,shape=Replicate) (if both Condition and Replicate are names in the Coldata table).

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\seealso{
\link{GetData}, \link{PlotGeneOldVsNew},\link{PlotGeneGroupsPoints},\link{PlotGeneGroupsBars}
}
\concept{geneplot}
