% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_season_stats.R
\name{load_tournament_detail}
\alias{load_tournament_detail}
\title{Load Tournament with Hole-by-Hole Scores}
\usage{
load_tournament_detail(year, tournament, top_n = 10, tour = "pga")
}
\arguments{
\item{year}{Season year (e.g., 2025)}

\item{tournament}{Tournament name (partial match) or event_id}

\item{top_n}{Only fetch scorecards for top N finishers (default: 10)}

\item{tour}{Tour name: "pga" (default), "liv", "lpga", "euro", or "champions".}
}
\value{
List with 'leaderboard' and 'scorecards' tibbles
}
\description{
Fetch full tournament data including hole-by-hole scorecards.
}
\examples{
\donttest{
# Get Masters with top 10 scorecards
masters_detail <- load_tournament_detail(2025, "Masters", top_n = 10)
}
}
