% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure-level.R
\name{get_structure_level}
\alias{get_structure_level}
\title{Get the Structure Resolution Levels}
\usage{
get_structure_level(x)
}
\arguments{
\item{x}{A \code{\link[=glycan_structure]{glycan_structure()}} vector.}
}
\value{
A character vector of the same length as \code{x},
containing the structure level for each element.
}
\description{
Glycan structures can have four possible levels of resolution:
\itemize{
\item "intact": All monosaccharides are concrete (e.g. "Man", "GlcNAc"),
and all linkages are fully determined (e.g. "a2-3", "b1-4").
\item "partial": All monosaccharides are concrete (e.g. "Man", "GlcNAc"),
but some linkage information is missing (e.g. "a2-?").
\item "topological": All monosaccharides are concrete (e.g. "Man", "GlcNAc"),
but the linkage information is completely unknown ("??-?").
\item "basic": All monosaccharides are generic (e.g. "Hex", "HexNAc"),
and the linkage information is completely unknown ("??-?").
}

Note that in theory you can have a glycan with generic monosaccharides with all linkages determined.
For example, "Hex(b1-3)HexNAc(a1-" is a valid glycan structure.
But in reality, this is almost impossible,
because linkage information is far more difficult to acquire than monosaccharide information.
This kind of glycan structure is also assigned to "basic" level.
}
\examples{
structures <- as_glycan_structure(c(
  "Gal(b1-3)GalNAc(a1-",
  "Gal(b1-?)GalNAc(a1-",
  "Gal(??-?)GalNAc(??-",
  "Hex(??-?)HexNAc(??-",
  "Hex(b1-3)HexNAc(a1-"
))
get_structure_level(structures)

}
\seealso{
\code{\link[=has_linkages]{has_linkages()}}, \code{\link[=get_mono_type]{get_mono_type()}}
}
