% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{delete_glmSTARMA_data}
\alias{delete_glmSTARMA_data}
\title{Delete cached example datasets}
\usage{
delete_glmSTARMA_data(name = NULL)
}
\arguments{
\item{name}{Name(s) of the dataset(s) to delete. One or more of \code{"rota"}, \code{"chickenpox"}, or \code{"sst"}. If \code{NULL} (default), no action is taken.}
}
\value{
Invisibly returns \code{TRUE} if all specified datasets were deleted, \code{FALSE} otherwise.
}
\description{
Delete one or more cached example datasets downloaded via \code{load_data()}.
}
\details{
This function deletes datasets that were previously downloaded and cached using \code{load_data()}
from the user-specific data directory.
If no datasets are found in the cache, a message is printed and no action is taken.
}
\examples{
delete_glmSTARMA_data("chickenpox")  # Only gives a message if dataset is not cached
}
\seealso{
\code{\link{load_data}}, \code{\link{rota}}, \code{\link{chickenpox}}, \code{\link{sst}}
}
