% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-anova.R
\name{print.anova.gkwreg}
\alias{print.anova.gkwreg}
\title{Print Method for ANOVA of GKw Models}
\usage{
\method{print}{anova.gkwreg}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars", TRUE),
  dig.tst = digits,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"anova.gkwreg"} from \code{\link{anova.gkwreg}}.}

\item{digits}{Minimum number of significant digits to print. Default is
\code{max(getOption("digits") - 2, 3)}.}

\item{signif.stars}{Logical; if \code{TRUE} (default), significance stars are
printed alongside p-values. Can be controlled globally via
\code{options(show.signif.stars = FALSE)}.}

\item{dig.tst}{Number of digits for test statistics. Default is \code{digits}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
The object \code{x}, invisibly.
}
\description{
Print method for analysis of deviance tables produced by \code{\link{anova.gkwreg}}.
}
\seealso{
\code{\link{anova.gkwreg}}
}
\author{
Lopes, J. E.
}
