% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{coef.gkwreg}
\alias{coef.gkwreg}
\title{Extract Coefficients from a Fitted GKw Regression Model}
\usage{
\method{coef}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically the result of a
call to \code{\link{gkwreg}}.}

\item{...}{Additional arguments, currently ignored by this method.}
}
\value{
A named numeric vector containing the estimated regression coefficients
for all modeled parameters. The names indicate the parameter (e.g., \code{alpha},
\code{beta}) and the corresponding predictor variable (e.g., \code{(Intercept)}, \code{x1}).
}
\description{
Extracts the estimated regression coefficients from a fitted Generalized
Kumaraswamy (GKw) regression model object of class \code{"gkwreg"}. This is
an S3 method for the generic \code{\link[stats]{coef}} function.
}
\details{
This function provides the standard way to access the estimated regression
coefficients from a model fitted with \code{\link{gkwreg}}. It simply
extracts the \code{coefficients} component from the fitted model object.
The function \code{\link[stats]{coefficients}} is an alias for this function.
}
\seealso{
\code{\link{gkwreg}}, \code{\link{summary.gkwreg}},
\code{\link[stats]{coef}}, \code{\link[stats]{confint}}
}
\author{
Lopes, J. E.
}
\keyword{coefficients}
\keyword{methods}
\keyword{regression}
