% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gipsmult_class.R
\name{gipsmult}
\alias{gipsmult}
\alias{new_gipsmult}
\title{The constructor of a \code{gipsmult} class.}
\usage{
gipsmult(
  Ss,
  numbers_of_observations,
  delta = 3,
  D_matrices = NULL,
  was_mean_estimated = TRUE,
  perm = ""
)

new_gipsmult(
  list_of_gips_perm,
  Ss,
  numbers_of_observations,
  delta,
  D_matrices,
  was_mean_estimated,
  optimization_info
)
}
\arguments{
\item{Ss}{A list of matrices; empirical covariance matrices.
When \code{Z} is the observed data from single class:
\itemize{
\item if one does not know the theoretical mean and has to
estimate it with the observed mean, use \code{S = cov(Z)},
and leave parameter \code{was_mean_estimated = TRUE} as default;
\item if one know the theoretical mean is 0, use
\code{S = (t(Z) \%*\% Z) / number_of_observations}, and set
parameter \code{was_mean_estimated = FALSE}.
}}

\item{numbers_of_observations}{Numbers of data points
that \code{Ss} is based on.}

\item{delta}{A number, hyper-parameter of a Bayesian model.
It has to be strictly bigger than 1.
See the \strong{Hyperparameters} section below.}

\item{D_matrices}{A list of symmetric, positive-definite matrices of the same size as matrices in \code{Ss}.
Hyper-parameter of a Bayesian model.
When \code{NULL}, the (hopefully) reasonable one is derived from the data.
For more details, see the \strong{Hyperparameters} section below.}

\item{was_mean_estimated}{A boolean.
\itemize{
\item Set \code{TRUE} (default) when your \code{S} parameter is a result of
a \code{\link[stats:cor]{stats::cov()}} function.
\item Set FALSE when your \code{S} parameter is a result of
a \code{(t(Z) \%*\% Z) / number_of_observations} calculation.
}}

\item{perm}{An optional permutation to be the base for the \code{gipsmult} object.
It can be of a \code{gips_perm} or a \code{permutation} class, or anything
the function \code{\link[permutations:permutation]{permutations::permutation()}} can handle.
It can also be of a \code{gipsmult} class, but
it will be interpreted as the underlying \code{gips_perm}.}

\item{list_of_gips_perm}{A list with a single element of
a \code{gips_perm} class. The base object for the \code{gipsmult} object.}

\item{optimization_info}{For internal use only. \code{NULL} or the list with
information about the optimization process.}
}
\value{
\code{gipsmult()} returns an object of
a \code{gipsmult} class after the safety checks.

\code{new_gipsmult()} returns an object of
a \code{gipsmult} class without the safety checks.
}
\description{
Create a \code{gipsmult} object.
This object will contain initial data and all other information
needed to find the most likely invariant permutation.
It will not perform optimization. One must call
the \code{\link[=find_MAP]{find_MAP()}} function to do it. See the examples below.
}
\section{Functions}{
\itemize{
\item \code{new_gipsmult()}: Constructor. It is only intended for low-level use.

}}
\section{Methods for a \code{gipsmult} class}{

\itemize{
\item \code{\link[=plot.gipsmult]{plot.gipsmult()}}
\item \code{\link[=print.gipsmult]{print.gipsmult()}}
}
}

\section{Hyperparameters}{

We encourage the user to try \code{D_matrix = d * I}, where \code{I} is an identity matrix of a size
\verb{p x p} and \code{d > 0} for some different \code{d}.
When \code{d} is small compared to the data (e.g., \code{d = 0.1 * mean(diag(S))}),
bigger structures will be found.
When \code{d} is big compared to the data (e.g., \code{d = 100 * mean(diag(S))}),
the posterior distribution does not depend on the data.

Taking \code{D_matrix = d * I} is equivalent to setting \code{S <- S / d}.

The default for \code{D_matrix} is \code{D_matrix = d * I}, where
\code{d = mean(diag(S))}, which is equivalent to modifying \code{S}
so that the mean value on the diagonal is 1.

In the Bayesian model, the prior distribution for
the covariance matrix is a generalized case of
\href{https://en.wikipedia.org/wiki/Wishart_distribution}{Wishart distribution}.
}

\examples{
perm_size <- 5
numbers_of_observations <- c(15, 18, 19)
Sigma <- diag(rep(1, perm_size))
n_matrices <- 3
df <- 20
Ss <- rWishart(n = n_matrices, df = df, Sigma = Sigma)
Ss <- lapply(1:n_matrices, function(x) Ss[, , x])
g <- gipsmult(Ss, numbers_of_observations)

g_map <- find_MAP(g, show_progress_bar = FALSE, optimizer = "brute_force")
g_map

print(g_map)

if (require("graphics")) {
  plot(g_map, type = "MLE", logarithmic_x = TRUE)
}
}
\seealso{
\itemize{
\item \code{\link[stats:cor]{stats::cov()}} – The \code{Ss} parameter, as a list of empirical covariance matrices,
is most of the time a result of the \code{cov()} function.
For more information, see
\href{https://en.wikipedia.org/wiki/Estimation_of_covariance_matrices}{Wikipedia - Estimation of covariance matrices}.
\item \code{\link[=find_MAP]{find_MAP()}} – The function that finds
the Maximum A Posteriori (MAP) Estimator
for a given \code{gipsmult} object.
\item \code{\link[gips:gips_perm]{gips::gips_perm()}} – The constructor of a \code{gips_perm} class.
The \code{gips_perm} object is used as the base object for
the \code{gipsmult} object.
}
}
