% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.poolaccum.R
\name{fortify.poolaccum}
\alias{fortify.poolaccum}
\alias{tidy.poolaccum}
\title{Fortify extrapolated species richness of a species pool}
\usage{
\method{fortify}{poolaccum}(model, data, alpha = 0.05, ...)

\method{tidy}{poolaccum}(x, data, alpha = 0.05, ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:specpool]{vegan::poolaccum()}}.}

\item{data}{original data set. Currently ignored.}

\item{alpha}{level of quantiles for envelopes shown (default 0.05).}

\item{...}{additional arguments passed to \code{\link[vegan:specpool]{vegan::summary.poolaccum()}},
notably \code{display} to control which indices should be computed.}
}
\value{
A data frame with columns \code{index}, \code{size}, \code{richness}, \code{lower},
\code{upper}, and \code{std_dev}, containing the richness index, permutation richness
estimator, sample size, upper and lower \eqn{1 - \alpha}{1 - alpha}
quantile interval, and standard deviation of permutation estimates,
respectively.
}
\description{
Prepares a fortified version of results from
\code{\link[vegan:specpool]{vegan::poolaccum()}} objects.
}
\examples{

library("vegan")
library("ggplot2")
data(BCI)
pool <- poolaccum(BCI)
df <- fortify(pool)
df

ggplot(df, aes(x = size, y = richness, colour = index)) +
    geom_ribbon(aes(ymin = lower, ymax = upper, x = size, fill = index),
                alpha = 0.3, inherit.aes = FALSE) +
    geom_line() +
    facet_wrap(~ index)
}
\author{
Gavin L. Simpson & Didzis Elferts
}
