% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.vegan_pco.R
\name{autoplot.vegan_pco}
\alias{autoplot.vegan_pco}
\title{ggplot-based plot for objects of class \code{"vegan_pco"}}
\usage{
\method{autoplot}{vegan_pco}(
  object,
  geom = "point",
  legend.position = "right",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab = NULL,
  xlab = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"vegan_pco"}, the result of a call
to \code{\link[vegan:dbrda]{vegan::pco()}}.}

\item{geom}{character; which geom to use for the site (sample) scores. One
of \code{"point"}, or \code{"text"}.}

\item{legend.position}{character or two-element numeric vector; where to
position the legend. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for details. Use \code{"none"}
to not draw the legend.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{ylab}{character; label for the y-axis.}

\item{xlab}{character; label for the x-axis.}

\item{...}{Additional arguments passed to the \code{\link[=fortify]{fortify()}} method.}
}
\value{
Returns a ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of
objects produced by \code{\link[vegan:dbrda]{vegan::pco()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)

sol <- pco(dune)
autoplot(sol)
}
\author{
Gavin L. Simpson
}
