% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.permustats.R
\name{autoplot.permustats}
\alias{autoplot.permustats}
\title{Autoplot Graphics for vegan permustats Objects}
\usage{
\method{autoplot}{permustats}(
  object,
  plot = c("box", "violin", "density", "qqnorm"),
  scale = FALSE,
  facet = FALSE,
  gg.params = list(),
  ...
)
}
\arguments{
\item{object}{object from \code{\link[vegan:permustats]{vegan::permustats()}}.}

\item{plot}{character; the type of plot, or a geom from \pkg{ggplot2}.}

\item{scale}{logical; use standardized effect sizes (SES)?}

\item{facet}{logical; should the plot be faceted by \code{term}?}

\item{gg.params}{list; arguments passed to function drawing the box-like
object. Depending on argument \code{plot} the parameters are passed to
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}, \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}},
\code{\link[ggplot2:geom_density]{ggplot2::geom_density()}} or \code{\link[ggplot2:geom_qq]{ggplot2::geom_qq()}}.}

\item{...}{Other parameters passed to functions (ignored).}
}
\value{
Returns a ggplot object.
}
\description{
Alternatives for \pkg{lattice} graphics functions
\code{\link[vegan:permustats]{vegan::densityplot.permustats()}},
\code{\link[vegan:permustats]{vegan::densityplot.permustats()}} and
\code{\link[vegan:permustats]{vegan::boxplot.permustats()}}.
}
\details{
Function \code{fortify()} returns a data frame with variables \code{permutations}
(numeric) and \code{term} (factor labelling the permutation). The result of
\code{fortify()} can be used to custom build diagnostic plots. \code{autoplot()}
provides basic plots of \code{\link[vegan:permustats]{vegan::permustats()}} objects with limited
flexibility.
}
\examples{

library("vegan")

data(dune, dune.env)
mod <- cca(dune ~ A1 + Management + Moisture, dune.env)
(ano <- anova(mod, by = "onedf"))
pstat <- permustats(ano)
head(fortify(pstat))
autoplot(pstat, "box")


if (requireNamespace("ggplot2")) {
  library("ggplot2")

  # avoid overplotting x-axis text
  autoplot(pstat, "violin") +
    scale_x_discrete(guide = guide_axis(n.dodge = 2))

  autoplot(pstat, "qqnorm", facet = TRUE) +
    geom_qq_line()
}

autoplot(pstat, "density", facet = TRUE)
}
