% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.fisherfit.R
\name{autoplot.fisherfit}
\alias{autoplot.fisherfit}
\title{Plot Fisher's log-series}
\usage{
\method{autoplot}{fisherfit}(
  object,
  show.fitted = TRUE,
  xlab = "Abundance",
  ylab = "Number of Species",
  title = "Fisher's log-series distribution",
  bar.col = NA,
  bar.fill = "grey35",
  line.col = "red",
  linewidth = 0.7,
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{\link[vegan:fisherfit]{vegan::fisherfit()}}.}

\item{show.fitted}{logical; should the estimated distribution also be
plotted?}

\item{xlab}{character; label for the x axis.}

\item{ylab}{character; label for the y axis.}

\item{title}{character; subtitle for the plot.}

\item{bar.col}{colour for the bar outlines. The default, \code{NA}, does not
draw outlines around bars.}

\item{bar.fill}{fill colour for the bars.}

\item{line.col}{colour for Fisher's log-series curve.}

\item{linewidth}{numeric; linewidth aesthetic for the log-series curve.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{...}{additional arguments passed to other methods.}
}
\value{
A ggplot object.
}
\description{
Draws a bar plot of species rank abundance with Fisher's
log-series superimposed.
}
\examples{

library("vegan")

data(BCI)
mod <- fisherfit(BCI[5,])
autoplot(mod)
}
\author{
Gavin L. Simpson
}
