% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqdplot.R
\name{ggseqdplot}
\alias{ggseqdplot}
\title{Sequence Distribution Plot}
\usage{
ggseqdplot(
  seqdata,
  no.n = FALSE,
  group = NULL,
  dissect = NULL,
  weighted = TRUE,
  with.missing = FALSE,
  border = FALSE,
  with.entropy = FALSE,
  linetype = "dashed",
  linecolor = "black",
  linewidth = 1,
  facet_ncol = NULL,
  facet_nrow = NULL,
  ...
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{no.n}{specifies if number of (weighted) sequences is shown (default is \code{TRUE})}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{dissect}{if \code{"row"} or \code{"col"} are specified separate distribution plots instead of a stacked plot are displayed;
\code{"row"} and \code{"col"} display the distributions in one row or one column respectively; default is \code{NULL}}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{with.missing}{Specifies if missing states should be considered when computing the state distributions (default is \code{FALSE}).}

\item{border}{if \code{TRUE} bars are plotted with black outline; default is \code{FALSE} (also accepts \code{NULL})}

\item{with.entropy}{add line plot of cross-sectional entropies at each sequence position}

\item{linetype}{The linetype for the entropy subplot (\code{with.entropy==TRUE}) can be specified with an integer (0-6) or name (0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 4 = dotdash, 5 = longdash, 6 = twodash); ; default is \code{"dashed"}}

\item{linecolor}{Specifies the color of the entropy line if \code{with.entropy==TRUE}; default is \code{"black"}}

\item{linewidth}{Specifies the width of the entropy line if \code{with.entropy==TRUE}; default is \code{1}}

\item{facet_ncol}{Number of columns in faceted (i.e. grouped) plot}

\item{facet_nrow}{Number of rows in faceted (i.e. grouped) plot}

\item{...}{if group is specified additional arguments of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap}}
such as \code{"labeller"} or \code{"strip.position"} can be used to change the appearance of the plot. Does
not work if \code{dissect} is used}
}
\value{
A sequence distribution plot created by using \code{\link[ggplot2]{ggplot2}}.
If stored as object the resulting list object (of class gg and ggplot) also
contains the data used for rendering the plot.
}
\description{
Function for rendering state distribution plots with \code{\link[ggplot2]{ggplot2}}
\insertCite{wickham2016}{ggseqplot} instead of base R's \code{\link[base]{plot}}
function that is used by \code{\link[TraMineR:seqplot]{TraMineR::seqplot}}
\insertCite{gabadinho2011}{ggseqplot}.
}
\details{
Sequence distribution plots visualize the distribution of all states
by rendering a series of stacked bar charts at each position of the sequence.
Although this type of plot has been used in the life course studies for several
decades (see \insertCite{blossfeld1987;textual}{ggseqplot} for an early application),
it should be noted that the size of the different bars in stacked bar charts
might be difficult to compare - particularly if the alphabet comprises many
states  \insertCite{wilke2019}{ggseqplot}. This issue can be addressed by breaking down
the aggregated  distribution specifying the \code{dissect} argument.  Moreover, it
is important to keep in mind that this plot type does not visualize individual
trajectories; instead it displays aggregated distributional information
(repeated cross-sections). For a more detailed discussion of this  type of
sequence visualization see, for example, \insertCite{brzinsky-fay2014;textual}{ggseqplot},
\insertCite{fasang2014;textual}{ggseqplot}, and \insertCite{raab2022;textual}{ggseqplot}.

The function uses \code{\link[TraMineR:seqstatd]{TraMineR::seqstatd}} to obtain state
distributions (and entropy values). This requires that the input data (\code{seqdata})
are stored as state sequence object (class \code{stslist}) created with
the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function. The state distributions
are reshaped into a a long data format to enable plotting with \code{\link[ggplot2]{ggplot2}}.
The stacked bars are rendered by calling \code{\link[ggplot2]{geom_bar}}; if \code{entropy = TRUE}
entropy values are plotted with \code{\link[ggplot2]{geom_line}}. If the \code{group} or the
\code{dissect} argument are specified the sub-plots are produced by using
\code{\link[ggplot2]{facet_wrap}}. If both are specified the plots are rendered with
\code{\link[ggplot2]{facet_grid}}.

The data and specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+} and
the respective functions).
}
\examples{
library(TraMineR)
library(ggplot2)

# Use example data from TraMineR: actcal data set
data(actcal)

# We use only a sample of 300 cases
set.seed(1)
actcal <- actcal[sample(nrow(actcal), 300), ]
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal, 13:24, labels = actcal.lab)

# state distribution plots; grouped by sex
# with TraMineR::seqplot
seqdplot(actcal.seq, group = actcal$sex)
# with ggseqplot
ggseqdplot(actcal.seq, group = actcal$sex)
# with ggseqplot applying a few additional arguments, e.g. entropy line
ggseqdplot(actcal.seq, group = actcal$sex,
           no.n = TRUE, with.entropy = TRUE, border = TRUE)

# break down the stacked plot to ease comparisons of distributions
ggseqdplot(actcal.seq, group = actcal$sex, dissect = "row")

# make use of ggplot functions for modifying the plot
ggseqdplot(actcal.seq) +
  scale_x_discrete(labels = month.abb) +
  labs(title = "State distribution plot", x = "Month") +
  guides(fill = guide_legend(title = "Alphabet")) +
  theme_classic() +
  theme(plot.title = element_text(size = 30,
                                  margin = margin(0, 0, 20, 0)),
    plot.title.position = "plot")

}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
