% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-plot.R
\name{geom_plot}
\alias{geom_plot}
\alias{geom_plot_npc}
\title{Inset plots}
\usage{
geom_plot(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  default.colour = NULL,
  default.color = default.colour,
  colour.target = "box",
  color.target = colour.target,
  default.alpha = 1,
  alpha.target = "all",
  add.segments = TRUE,
  box.padding = 0.25,
  point.padding = 1e-06,
  segment.linewidth = 0.5,
  min.segment.length = 0,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_plot_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each "label". The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{default.colour, default.color}{A colour definition to use for elements not targeted by
the colour aesthetic.}

\item{colour.target, color.target}{A vector of character strings; \code{"all"},
\code{"text"}, \code{"box"} and \code{"segment"}.}

\item{default.alpha}{numeric in [0..1] A transparency value to use for
elements not targeted by the alpha aesthetic.}

\item{alpha.target}{A vector of character strings; \code{"all"},
\code{"text"}, \code{"segment"}, \code{"box"}, \code{"box.line"}, and
\code{"box.fill"}.}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{box.padding, point.padding}{numeric By how much each end of the segments
should shortened in mm.}

\item{segment.linewidth}{numeric Width of the segments or arrows in mm.}

\item{min.segment.length}{numeric Segments shorter that the minimum length
are not rendered, in mm.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance.
}
\description{
\code{geom_plot} and \code{geom_plot_npc} add ggplot objects as insets to the
base ggplot, using syntax similar to that of
\code{\link[ggplot2]{geom_label}} and \code{\link{geom_text_s}}.
In most respects they behave as any other ggplot geometry: they add a layer
containing one or more grobs and grouping and faceting works as usual. The
most common use of \code{geom_plot} is to add data labels that are themselves
ggplots rather than text. \code{\link{geom_plot_npc}} is used to add ggplots
as annotations to plots, but contrary to layer function \code{annotate()},
\code{\link{geom_plot_npc}} is data driven and respects grouping and facets,
thus plot insets can differ among panels.
}
\details{
You can modify the size of inset plots with the \code{vp.width} and
  \code{vp.height} aesthetics. These can take a number between 0 (smallest
  possible inset) and 1 (whole plotting area width or height). The default
  value for for both of these aesthetics is 1/5. Thus, in contrast to
  \code{\link[ggplot2]{geom_text}} and \code{\link{geom_text_s}} the size of
  the insets remains the same relative to the size of the plotting area
  irrespective of how the plot is rendered. The aspect ratio of insets is
  preserved and size is adjusted until the whole inset fits within the
  viewport.

  \code{geom_plot} and \code{geom_plot_npc} expect a list of ggplot objects
  (\code{"gg"} class) to be mapped to the \code{label} aesthetic. These geoms
  work with tibbles or data frames as \code{data} as they both support
  \code{list} objects as member variables.

  The \code{x} and \code{y} aesthetics determine the position of the whole
  inset plot, similarly to that of a text label, justification is interpreted
  as indicating the position of the plot with respect to its x and y
  coordinates in the data, and \code{angle} is used to rotate the plot as a
  whole.

  Of these two geoms only \code{\link{geom_plot}} supports the plotting of
  segments, as \code{\link{geom_plot_npc}} uses a coordinate system that is
  unrelated to data units and data.In the case of \code{geom_plot_npc()},
  \code{npcx} and \code{npcy} aesthetics determine the position of the inset
  plot.
}
\note{
The insets are stored nested within the main ggplot object and
  contain their own copy of the data, and are rendered as grid grobs as normal
  ggplots at the time the main ggplot is rendered. They can have different
  themes.

  Use \code{\link{annotate}} as redefined in 'ggpp' when adding insets
  as annotations (automatically available unless 'ggpp' is not attached).
  \code{\link[ggplot2]{annotate}} cannot be used with the \code{npcx} and
  \code{npcy} pseudo-aesthetics.
}
\section{Alignment}{
 You can modify text alignment with the \code{vjust} and
  \code{hjust} aesthetics. These can either be a number between 0
  (right/bottom) and 1 (top/left) or a character (\code{"left"},
  \code{"middle"}, \code{"right"}, \code{"bottom"}, \code{"center"},
  \code{"top"}). In addition, you can use special alignments for
  justification including \code{"position"}, \code{"inward"} and
  \code{"outward"}. Inward always aligns text towards the center of the
  plotting area, and outward aligns it away from the center of the plotting
  area. If tagged with \code{_mean} or \code{_median} (e.g.,
  \code{"outward_mean"}) the mean or median of the data in the panel along
  the corresponding axis is used as center. If the characters following the
  underscore represent a number (e.g., \code{"outward_10.5"}) the reference
  point will be this value in data units. Position justification is computed
  based on the direction of the displacement of the position of the label so
  that each individual text or label is justified outwards from its original
  position. The default justification is \code{"position"}.

  If no position displacement is applied, or a position function defined in
  'ggplot2' is used, these geometries behave similarly to the corresponding
  ones from package 'ggplot2' with a default justification of \code{0.5} and
  no segment drawn.
}

\section{Position functions}{
 Many layer functions from package 'ggpp' are
  designed to work seamlessly with position functions that keep, rather than
  discard, the original \code{x} and \code{y} positions in \code{data} when
  computing a new displaced position. See \code{\link{position_nudge_keep}},
  \code{\link{position_dodge_keep}}, \code{\link{position_jitter_keep}},
  \code{\link{position_nudge_center}}, \code{\link{position_nudge_line}},
  \code{\link{position_nudge_to}}, \code{\link{position_dodgenudge}},
  \code{\link{position_jitternudge}}, and \code{\link{position_stacknudge}}
  for examples and details of their use.
}

\section{Plot boundaries and clipping}{
 The "width" and "height" of an inset
  as for a text element are 0, so stacking and dodging inset plots will not
  work by default, and axis limits are not automatically expanded to include
  all inset plots. Obviously, insets do have height and width, but they are
  physical units, not data units. The amount of space they occupy on the main
  plot is not constant in data units of the base plot: when you modify scale
  limits, inset plots stay the same size relative to the physical size of the
  base plot.
}

\examples{
# inset plot with enlarged detail from a region of the main plot
library(tibble)
p <-
  ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point()

p.crop <- p +
          coord_cartesian(xlim = c(3, 4),
          ylim = c(13, 16)) +
          labs(x = NULL, y = NULL) +
          theme_bw(10)

df <- data.frame(x = 0.01,
                 y = 0.01,
                 plot = I(list(p.crop)))
p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot))

p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot,
                vp.width = 1/2, vp.height = 1/4))

p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot),
                vp.width = 1/4, vp.height = 1/4)

p +
  geom_plot(data = df,
            aes(x = x + 3, y = y + 20, label = plot),
            nudge_x = -1, nudge_y = - 7,
            hjust = 0.5, vjust = 0.5,
            arrow = arrow(length = unit(0.5, "lines")),
            colour = "red",
            vp.width = 1/5, vp.height = 1/5)

}
\references{
The idea of implementing a \code{geom_custom()} for grobs has
  been discussed as an issue at
  \url{https://github.com/tidyverse/ggplot2/issues/1399}.
}
\seealso{
Other geometries adding layers with insets: 
\code{\link{geom_table}()}
}
\concept{geometries adding layers with insets}
