% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPedigreeInteractive.R
\name{optimizeStaticPedigree}
\alias{optimizeStaticPedigree}
\title{Optimize Static Pedigree Plot}
\usage{
optimizeStaticPedigree(
  p,
  config = list(),
  variable_drop = c("parent_hash", "couple_hash", "gen", "spousehint", "parent_fam",
    "nid", "x_order", "y_order", "y_fam", "zygosity", "extra", "x_fam")
)
}
\arguments{
\item{p}{A ggplot object representing the pedigree plot.}

\item{config}{A list of configuration parameters, including `value_rounding_digits`.}

\item{variable_drop}{A character vector of variable names to be removed from the data frame.
Default variables to drop include "parent_hash", "couple_hash", "gen",
"spousehint", "parent_fam", "nid", "x_order",
"y_order", "y_fam", "zygosity", "extra", and "x_fam".}
}
\value{
The optimized ggplot object with rounded coordinates and reduced data frame.
}
\description{
Optimize a static pedigree plot by rounding coordinates to reduce file size
and removing unnecessary variables from the data frame.
}
\keyword{internal}
