% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_step}
\alias{ggml_step}
\title{Step Function (Graph)}
\usage{
ggml_step(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the step operation
}
\description{
Creates a graph node for element-wise step function.
step(x) = 0 if x <= 0, 1 if x > 0
Also known as the Heaviside step function.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -0.5, 0, 0.5, 2))
r <- ggml_step(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)  # c(0, 0, 0, 1, 1)
ggml_free(ctx)
}
}
