% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{ggml_set_abort_callback_r}
\alias{ggml_set_abort_callback_r}
\title{Enable R-compatible Abort Handling}
\usage{
ggml_set_abort_callback_r()
}
\value{
NULL invisibly
}
\description{
Converts GGML abort calls into R errors (via Rf_error).
This allows R to catch GGML failures with tryCatch.
}
\examples{
\donttest{
ggml_set_abort_callback_r()
# Now GGML aborts will become R errors
result <- tryCatch({
  # ... ggml operations that might fail ...
}, error = function(e) {
  message("GGML error caught: ", e$message)
})
}
}
\seealso{
Other logging: 
\code{\link{ggml_abort_is_r_enabled}()},
\code{\link{ggml_log_is_r_enabled}()},
\code{\link{ggml_log_set_default}()},
\code{\link{ggml_log_set_r}()},
\code{\link{ggml_set_abort_callback_default}()}
}
\concept{logging}
