% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{ggml_backend_graph_compute_async}
\alias{ggml_backend_graph_compute_async}
\title{Compute graph asynchronously}
\usage{
ggml_backend_graph_compute_async(backend, graph)
}
\arguments{
\item{backend}{External pointer to backend}

\item{graph}{External pointer to computation graph}
}
\value{
Integer status code (0 = success)
}
\description{
Starts graph computation without blocking. Use ggml_backend_synchronize()
to wait for completion.
}
\examples{
\donttest{
cpu <- ggml_backend_cpu_init()
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 100)
b <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)
ggml_set_f32(a, rnorm(100))
# Start async computation
status <- ggml_backend_graph_compute_async(cpu, graph)
# Do other work while computation runs...
ggml_backend_synchronize(cpu)
ggml_backend_free(cpu)
ggml_free(ctx)
}
}
\seealso{
Other backend: 
\code{\link{ggml_backend_buffer_clear}()},
\code{\link{ggml_backend_buffer_get_usage}()},
\code{\link{ggml_backend_buffer_is_host}()},
\code{\link{ggml_backend_buffer_is_multi_buffer}()},
\code{\link{ggml_backend_buffer_reset}()},
\code{\link{ggml_backend_buffer_set_usage}()},
\code{\link{ggml_backend_buffer_usage_any}()},
\code{\link{ggml_backend_buffer_usage_compute}()},
\code{\link{ggml_backend_buffer_usage_weights}()},
\code{\link{ggml_backend_dev_by_name}()},
\code{\link{ggml_backend_dev_by_type}()},
\code{\link{ggml_backend_dev_count}()},
\code{\link{ggml_backend_dev_description}()},
\code{\link{ggml_backend_dev_get}()},
\code{\link{ggml_backend_dev_get_props}()},
\code{\link{ggml_backend_dev_init}()},
\code{\link{ggml_backend_dev_memory}()},
\code{\link{ggml_backend_dev_name}()},
\code{\link{ggml_backend_dev_offload_op}()},
\code{\link{ggml_backend_dev_supports_buft}()},
\code{\link{ggml_backend_dev_supports_op}()},
\code{\link{ggml_backend_dev_type}()},
\code{\link{ggml_backend_device_register}()},
\code{\link{ggml_backend_device_type_accel}()},
\code{\link{ggml_backend_device_type_cpu}()},
\code{\link{ggml_backend_device_type_gpu}()},
\code{\link{ggml_backend_device_type_igpu}()},
\code{\link{ggml_backend_event_free}()},
\code{\link{ggml_backend_event_new}()},
\code{\link{ggml_backend_event_record}()},
\code{\link{ggml_backend_event_synchronize}()},
\code{\link{ggml_backend_event_wait}()},
\code{\link{ggml_backend_get_device}()},
\code{\link{ggml_backend_graph_plan_compute}()},
\code{\link{ggml_backend_graph_plan_create}()},
\code{\link{ggml_backend_graph_plan_free}()},
\code{\link{ggml_backend_init_best}()},
\code{\link{ggml_backend_init_by_name}()},
\code{\link{ggml_backend_init_by_type}()},
\code{\link{ggml_backend_load}()},
\code{\link{ggml_backend_load_all}()},
\code{\link{ggml_backend_multi_buffer_alloc_buffer}()},
\code{\link{ggml_backend_multi_buffer_set_usage}()},
\code{\link{ggml_backend_reg_by_name}()},
\code{\link{ggml_backend_reg_count}()},
\code{\link{ggml_backend_reg_dev_count}()},
\code{\link{ggml_backend_reg_dev_get}()},
\code{\link{ggml_backend_reg_get}()},
\code{\link{ggml_backend_reg_name}()},
\code{\link{ggml_backend_register}()},
\code{\link{ggml_backend_synchronize}()},
\code{\link{ggml_backend_tensor_copy_async}()},
\code{\link{ggml_backend_tensor_get_async}()},
\code{\link{ggml_backend_tensor_set_async}()},
\code{\link{ggml_backend_unload}()}
}
\concept{backend}
