% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissert_bib.R
\name{dissert_bib}
\alias{dissert_bib}
\title{Function to prepare metadata of the main dissertations for automatic insertion into scientific articles}
\usage{
dissert_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a dissertation}

\item{input_tam}{is the length of the dataframe with the main scientifics dissertation, obtained using package bibliorefer.}
}
\value{
The output of the dissert_bib function is the file with the .bib extension, containing the list of dissertation references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\description{
The dissert_bib function prepares the metadata of the main dissertations to be automatically included in a scientific article. The dissert_bib function internally calls two support functions. The output of the dissert_bib function is the file with the .bib extension, containing the list of dissertation references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","dissertacao.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 10

#Calls the function monograf_bib
dissertlister_bibtex <- dissert_bib(input_date, input_tam)
dissertlister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
