% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_gerda_web.R
\name{load_gerda_web}
\alias{load_gerda_web}
\title{Load GERDA Data}
\usage{
load_gerda_web(file_name, verbose = FALSE, file_format = "rds")
}
\arguments{
\item{file_name}{A character string specifying the name of the file to load. For a list of available data, see \code{\link{gerda_data_list}}.}

\item{verbose}{A logical value indicating whether to print additional messages to the console. Default is FALSE.}

\item{file_format}{A character string specifying the format of the file. Must be either "csv" or "rds". Default is "rds".}
}
\value{
A tibble containing the loaded data, or NULL if the data could not be loaded.
}
\description{
This function loads GERDA data from a web source.
}
\examples{
\donttest{
# Load harmonized municipal elections data
data_municipal_harm <- load_gerda_web("municipal_harm", verbose = TRUE, file_format = "rds")

# Load federal election data harmonized to 2025 boundaries (includes 2025 election)
data_federal_2025 <- load_gerda_web("federal_muni_harm_25", verbose = TRUE, file_format = "rds")
}

}
