% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-package-info.R
\docType{package}
\name{geospatialsuite-package}
\alias{geospatialsuite}
\alias{geospatialsuite-package}
\title{geospatialsuite: Comprehensive Geospatiotemporal Analysis and Multimodal Integration Toolkit}
\description{
GeoSpatialSuite provides universal functions for geospatial analysis and reliable
visualization that work with any region for multimodal data. Features include
60+ vegetation indices, efficient terra-based visualization, universal spatial mapping,
dynamic crop analysis, water quality assessment, and publication-quality mapping with
support for any geographic region and robust error handling.
}
\details{
\subsection{Key Features:}{
\subsection{Universal Spatial Analysis:}{
\itemize{
\item Universal region support (states, countries, CONUS, custom boundaries)
\item Universal spatial join (works with ANY raster-vector combination)
\item Multi-dataset integration and temporal analysis
\item Spatial interpolation and terrain analysis
}
}

\subsection{Advanced Vegetation Analysis:}{
\itemize{
\item \strong{60+ vegetation indices} including NDVI, EVI, SAVI, ARVI, PRI, SIPI, etc.
\item \strong{Specialized crop analysis} with stress detection and yield assessment
\item \strong{Auto band detection} from multi-band satellite imagery
\item \strong{Quality filtering} and temporal smoothing for time series
}
}

\subsection{Reliable Visualization:}{
\itemize{
\item \strong{Universal mapping} with auto-detection (\code{quick_map()} function)
\item \strong{Terra-based plotting} using reliable terra::plot() and terra::plotRGB()
\item \strong{Interactive maps} with leaflet integration (optional)
\item \strong{RGB composites} with stretching algorithms
\item \strong{Comparison maps} for before/after analysis
}
}

\subsection{Agricultural Applications:}{
\itemize{
\item \strong{Dynamic CDL crop analysis} (all crop codes and categories)
\item \strong{NDVI time series} with classification
\item \strong{Crop-specific analysis} (corn, soybeans, wheat, etc.)
\item \strong{Water quality assessment} with threshold analysis
}
}

\subsection{Performance & Reliability Features:}{
\itemize{
\item \strong{Standard terra plotting} - no complex dependencies required
\item \strong{Robust error handling} throughout all functions
\item \strong{Simplified visualization} for maps
\item \strong{Smart fallback systems} when optional packages unavailable
}
}

}

\subsection{Quick Start Examples:}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# One-line mapping (auto-detects everything!)
quick_map("mydata.shp")

# Auto-geocode data without coordinates
census_data <- data.frame(
  state = c("Ohio", "Pennsylvania", "Michigan"),
  median_income = c(58642, 61744, 59584)
)
spatial_data <- auto_geocode_data(census_data)
quick_map(spatial_data, variable = "median_income")

# Works with HUC codes too (any format: HUC_8, HUC-8, huc8)
watershed_data <- data.frame(
  HUC_8 = c("04100009", "04100012"),
  water_quality = c(72, 65)
)
huc_spatial <- auto_geocode_data(watershed_data)
quick_map(huc_spatial)

# Calculate multiple vegetation indices
indices <- calculate_multiple_indices(
  red = red_band, nir = nir_band,
  indices = c("NDVI", "EVI", "SAVI", "PRI")
)

# Comprehensive crop analysis
crop_analysis <- analyze_crop_vegetation(
  spectral_data = sentinel_data,
  crop_type = "corn",
  analysis_type = "comprehensive"
)

# Enhanced NDVI calculation
ndvi_enhanced <- calculate_ndvi_enhanced(
  red_data = red_raster,
  nir_data = nir_raster,
  quality_filter = TRUE
)

# Fast, reliable RGB plotting
plot_rgb_raster(satellite_data, r = 4, g = 3, b = 2,
               stretch = "hist", title = "False Color")
}\if{html}{\out{</div>}}
}

\subsection{Recommended Optional Packages:}{

For enhanced features, consider installing these optional packages:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# For interactive mapping
install.packages("leaflet")

# For enhanced colors
install.packages(c("viridis", "RColorBrewer"))

# For advanced remote sensing (optional)
install.packages("RStoolbox")

# For multi-panel plots (optional)
install.packages("patchwork")
}\if{html}{\out{</div>}}
}

\subsection{Core Dependencies Only:}{

The package works reliably with just the core dependencies:
\itemize{
\item terra (raster operations and plotting)
\item sf (vector operations)
\item ggplot2 (static mapping)
\item dplyr (data manipulation)
}

No complex visualization dependencies required!
}
}
\author{
Olatunde D. Akanbi \email{olatunde.akanbi@case.edu}

Erika I. Barcelos \email{erika.barcelos@case.edu}

Roger H. French \email{roger.french@case.edu}
}
\keyword{geospatial}
\keyword{package}
\keyword{remote-sensing}
\keyword{vegetation-indices}
\keyword{visualization}
