% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-visualization.R
\name{create_spatial_map}
\alias{create_spatial_map}
\title{Create universal spatial map with reliable terra plotting}
\usage{
create_spatial_map(
  spatial_data,
  fill_variable = NULL,
  coord_cols = c("lon", "lat"),
  region_boundary = NULL,
  map_type = "auto",
  color_scheme = "viridis",
  interactive = FALSE,
  title = NULL,
  point_size = 3,
  output_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{spatial_data}{sf object, data.frame with coordinates, file path, or SpatRaster}

\item{fill_variable}{Variable to use for fill/color (for vector data)}

\item{coord_cols}{Coordinate column names if data.frame provided}

\item{region_boundary}{Optional region boundary}

\item{map_type}{Type of map: "points", "polygons", "raster", "auto"}

\item{color_scheme}{Color scheme: "viridis", "plasma", "ndvi", "terrain", "categorical"}

\item{interactive}{Create interactive map using leaflet (if available)}

\item{title}{Map title}

\item{point_size}{Size of points (for point data)}

\item{output_file}{Optional output file path}

\item{verbose}{Print progress messages}
}
\value{
ggplot2 object, leaflet map, or file path (depending on options)
}
\description{
Universal mapping function that works with any spatial data type using
reliable terra and base R plotting. No complex dependencies required.
Falls back gracefully when optional packages are unavailable.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Simple point map
create_spatial_map(study_sites, fill_variable = "ndvi_mean")

# Raster map with region boundary
create_spatial_map(ndvi_raster, region_boundary = "Ohio",
                  color_scheme = "ndvi")

# Interactive map (if leaflet available)
create_spatial_map(counties, fill_variable = "population",
                  interactive = TRUE)
}

}
