% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhumb.R
\name{rhumb_direct}
\alias{rhumb_direct}
\alias{rhumb_inverse}
\alias{rhumb_path}
\alias{rhumb_line}
\alias{rhumb_distance}
\alias{rhumb_distance_matrix}
\title{Rhumb line (loxodrome) calculations on the WGS84 ellipsoid}
\usage{
rhumb_direct(x, azi, s)

rhumb_inverse(x, y)

rhumb_path(x, y, n = 100L)

rhumb_line(x, azi, distances)

rhumb_distance(x, y)

rhumb_distance_matrix(x, y = NULL)
}
\arguments{
\item{x}{A two-column matrix or data frame of starting coordinates
(longitude, latitude) in decimal degrees.}

\item{azi}{Numeric vector of azimuths (bearings) in degrees, measured
clockwise from north.}

\item{s}{Numeric vector of distances in meters.}

\item{y}{A two-column matrix or data frame of ending coordinates
(longitude, latitude) in decimal degrees.}

\item{n}{Integer number of points to generate along the path (including
start and end points).}

\item{distances}{Numeric vector of distances from the starting point in meters.}
}
\value{
\itemize{
\item \code{rhumb_direct()}: Data frame with columns:
\itemize{
\item \code{lon1}, \code{lat1}: Starting coordinates
\item \code{azi12}: Azimuth (constant along rhumb line, degrees)
\item \code{s12}: Distance (meters)
\item \code{lon2}, \code{lat2}: Destination coordinates
\item \code{S12}: Area under rhumb line (square meters)
}
\item \code{rhumb_inverse()}: Data frame with columns:
\itemize{
\item \code{lon1}, \code{lat1}: Starting coordinates
\item \code{lon2}, \code{lat2}: Ending coordinates
\item \code{s12}: Distance (meters)
\item \code{azi12}: Azimuth (degrees)
\item \code{S12}: Area under rhumb line (square meters)
}
\item \code{rhumb_path()}: Data frame with columns:
\itemize{
\item \code{lon}, \code{lat}: Coordinates along the path
\item \code{s}: Distance from start (meters)
\item \code{azi12}: Constant azimuth (degrees)
}
\item \code{rhumb_line()}: Data frame with columns:
\itemize{
\item \code{lon}, \code{lat}: Coordinates at specified distances
\item \code{azi}: Azimuth (degrees)
\item \code{s}: Distance from start (meters)
}
\item \code{rhumb_distance()}: Numeric vector of distances in meters (pairwise).
\item \code{rhumb_distance_matrix()}: Matrix of distances in meters.
}
}
\description{
Solve rhumb line problems on the WGS84 ellipsoid. A rhumb line (or loxodrome)
is a path of constant bearing, which appears as a straight line on a Mercator
projection. Unlike geodesics, rhumb lines are not the shortest path between
two points, but they are easier to navigate as they maintain a constant
compass heading.
}
\details{
Rhumb lines are paths of constant azimuth (bearing). They are longer than
geodesics (up to 50\% longer for long distances) but are useful for navigation
because they can be followed with a constant compass heading.

The azimuth is measured in degrees from north, with positive values
clockwise (east) and negative values counter-clockwise (west).
The range is -180 to 180 degrees.

The area \code{S12} represents the area under the rhumb line quadrilateral
with corners at (lat1, lon1), (0, lon1), (0, lon2), and (lat2, lon2).
}
\examples{
# Direct problem: Where do you end up starting from London,
# heading east on a rhumb line for 1000 km?
rhumb_direct(c(-0.1, 51.5), azi = 90, s = 1000000)

# Inverse problem: Rhumb distance from London to New York
rhumb_inverse(c(-0.1, 51.5), c(-74, 40.7))

# Compare to geodesic (rhumb is longer!)
geodesic_inverse(c(-0.1, 51.5), c(-74, 40.7))$s12
rhumb_inverse(c(-0.1, 51.5), c(-74, 40.7))$s12

# Generate a rhumb line path
path <- rhumb_path(c(-0.1, 51.5), c(-74, 40.7), n = 10)
path
}
\seealso{
\code{\link[=geodesic_direct]{geodesic_direct()}} for shortest-path geodesic calculations.
}
